/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.stacks.AEKey;
import java.util.Comparator;
import net.minecraft.network.FriendlyByteBuf;

public class CraftingPlanSummaryEntry
implements Comparable<CraftingPlanSummaryEntry> {
    private static final Comparator<CraftingPlanSummaryEntry> COMPARATOR = Comparator.comparing(CraftingPlanSummaryEntry::getMissingAmount).thenComparing(CraftingPlanSummaryEntry::getCraftAmount).thenComparing(CraftingPlanSummaryEntry::getStoredAmount).thenComparing(CraftingPlanSummaryEntry::getAvailableAmount).reversed();
    private final AEKey what;
    private final long missingAmount;
    private final long storedAmount;
    private final long craftAmount;
    private final long availableAmount;

    public CraftingPlanSummaryEntry(AEKey what, long missingAmount, long storedAmount, long craftAmount, long availableAmount) {
        this.what = what;
        this.missingAmount = missingAmount;
        this.storedAmount = storedAmount;
        this.craftAmount = craftAmount;
        this.availableAmount = availableAmount;
    }

    public AEKey getWhat() {
        return this.what;
    }

    public long getMissingAmount() {
        return this.missingAmount;
    }

    public long getStoredAmount() {
        return this.storedAmount;
    }

    public long getCraftAmount() {
        return this.craftAmount;
    }

    public long getAvailableAmount() {
        return this.availableAmount;
    }

    @Override
    public int compareTo(CraftingPlanSummaryEntry o) {
        return COMPARATOR.compare(this, o);
    }

    public void write(FriendlyByteBuf buffer) {
        AEKey.writeKey(buffer, this.what);
        buffer.m_130103_(this.missingAmount);
        buffer.m_130103_(this.storedAmount);
        buffer.m_130103_(this.craftAmount);
        buffer.m_130103_(this.availableAmount);
    }

    public static CraftingPlanSummaryEntry read(FriendlyByteBuf buffer) {
        AEKey what = AEKey.readKey(buffer);
        long missingAmount = buffer.m_130258_();
        long storedAmount = buffer.m_130258_();
        long craftAmount = buffer.m_130258_();
        long availableAmount = buffer.m_130258_();
        return new CraftingPlanSummaryEntry(what, missingAmount, storedAmount, craftAmount, availableAmount);
    }
}

