/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CraftExporter {
    public static void exportCraft(JsonObject jso, LocalPlayer player, ExportType type) {
        String date = DateTimeFormatter.ofPattern("yyy-MM-dd.mm.ss").format(LocalDateTime.now());
        File file = new File(Minecraft.m_91087_().f_91069_ + "/ae2/exports/" + type.type + date + ".json");
        file.getParentFile().mkdirs();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jso));
            writer.close();
        }
        catch (IOException e) {
            AELog.error("Failed to export crafting status", e);
        }
        MutableComponent component = Component.m_237113_((String)file.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
        player.m_5661_((Component)PlayerMessages.CraftExported.text(component), false);
    }

    public static enum ExportType {
        CRAFTING_STATUS("status_"),
        CRAFTING_PLAN("plan_");

        public final String type;

        private ExportType(String type) {
            this.type = type;
        }
    }
}

