/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import net.minecraft.world.item.Item;

public enum CraftingUnitType implements ICraftingUnitType
{
    UNIT(0L),
    ACCELERATOR(0L),
    STORAGE_1K(1L),
    STORAGE_4K(4L),
    STORAGE_16K(16L),
    STORAGE_64K(64L),
    STORAGE_256K(256L),
    SINGULARITY(0x1FFFFFFFFFFFFFL),
    MONITOR(0L);

    private final long storageKb;

    private CraftingUnitType(long storageKb) {
        this.storageKb = storageKb;
    }

    @Override
    public long getStorageBytes() {
        return 1024L * this.storageKb;
    }

    @Override
    public int getAcceleratorThreads() {
        return this == ACCELERATOR ? 1 : 0;
    }

    @Override
    public Item getItemFromType() {
        BlockDefinition<AbstractCraftingUnitBlock> definition = switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UNIT -> AEBlocks.CRAFTING_UNIT;
            case ACCELERATOR -> AEBlocks.CRAFTING_ACCELERATOR;
            case STORAGE_1K -> AEBlocks.CRAFTING_STORAGE_1K;
            case STORAGE_4K -> AEBlocks.CRAFTING_STORAGE_4K;
            case STORAGE_16K -> AEBlocks.CRAFTING_STORAGE_16K;
            case STORAGE_64K -> AEBlocks.CRAFTING_STORAGE_64K;
            case STORAGE_256K -> AEBlocks.CRAFTING_STORAGE_256K;
            case SINGULARITY -> AEBlocks.CRAFTING_STORAGE_SINGULARITY;
            case MONITOR -> AEBlocks.CRAFTING_MONITOR;
        };
        return definition.m_5456_();
    }
}

