package appeng.crafting.pattern;

import java.util.Arrays;
import java.util.Objects;

import org.jetbrains.annotations.Nullable;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;

/**
 * An item that contains an encoded {@link AEProcessingPattern}.
 */
public class ProcessingPatternItem extends EncodedPatternItem {
    public ProcessingPatternItem(Properties properties) {
        super(properties);
    }

    @Nullable
    @Override
    public AEProcessingPattern decode(ItemStack stack, Level level, boolean tryRecovery) {
        return decode(AEItemKey.of(stack), level);
    }

    @Override
    public AEProcessingPattern decode(AEItemKey what, Level level) {
        if (what == null || !what.hasTag()) {
            return null;
        }

        try {
            return new AEProcessingPattern(what);
        } catch (Exception e) {
            return null;
        }
    }

    public ItemStack encode(GenericStack[] sparseInputs, GenericStack[] sparseOutputs) {
        return encode(sparseInputs, sparseOutputs, "");
    }

    public ItemStack encode(GenericStack[] sparseInputs, GenericStack[] sparseOutputs, String author) {
        if (Arrays.stream(sparseInputs).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("At least one input must be non-null.");
        }
        Objects.requireNonNull(sparseOutputs[0],
                "The first (primary) output must be non-null.");

        var stack = new ItemStack(this);
        ProcessingPatternEncoding.encodeProcessingPattern(stack.getOrCreateTag(), sparseInputs, sparseOutputs, author);
        return stack;
    }
}
