package appeng.client.guidebook;

import org.jetbrains.annotations.Nullable;

import net.minecraft.resources.ResourceLocation;

/**
 * Points to a guidebook page with an optional anchor within that page.
 *
 * @param pageId
 * @param anchor ID of an anchor in the page.
 */
public record PageAnchor(ResourceLocation pageId, @Nullable String anchor) {
    public static PageAnchor page(ResourceLocation pageId) {
        return new PageAnchor(pageId, null);
    }

    public static @Nullable PageAnchor of(guideme.PageAnchor pageAnchor) {
        if (pageAnchor == null) {
            return null;
        }
        return new PageAnchor(pageAnchor.pageId(), pageAnchor.anchor());
    }

    @Override
    public String toString() {
        if (anchor != null) {
            return pageId.toString() + "#" + anchor;
        } else {
            return pageId.toString();
        }
    }
}
