/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.misc.InterfaceBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.tools.NetworkToolItem;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.crafting.PatternProviderPart;
import appeng.parts.misc.InterfacePart;
import appeng.server.testplots.CraftingPatternHelper;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.util.SettingsFrom;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class MemoryCardTestPlots {
    private MemoryCardTestPlots() {
    }

    @TestPlot(value="memcard_export_bus")
    public static void testExportBus(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.cable(origin).part(Direction.WEST, AEParts.EXPORT_BUS).part(Direction.EAST, AEParts.EXPORT_BUS);
        plot.test(helper -> {
            ExportBusPart fromPart = helper.getPart(BlockPos.f_121853_, Direction.WEST, ExportBusPart.class);
            ExportBusPart toPart = helper.getPart(BlockPos.f_121853_, Direction.EAST, ExportBusPart.class);
            Player player = helper.m_177368_();
            InternalInventory networkToolInv = MemoryCardTestPlots.addNetworkToolToPlayer(player);
            fromPart.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            fromPart.getUpgrades().addItems(AEItems.FUZZY_CARD.stack());
            fromPart.getUpgrades().addItems(AEItems.CRAFTING_CARD.stack());
            fromPart.getUpgrades().addItems(AEItems.CAPACITY_CARD.stack());
            fromPart.getConfig().addFilter((ItemLike)Items.f_42398_);
            fromPart.getConfig().addFilter((Fluid)Fluids.f_76193_);
            fromPart.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE);
            fromPart.getConfigManager().putSetting(Settings.FUZZY_MODE, FuzzyMode.PERCENT_25);
            fromPart.getConfigManager().putSetting(Settings.CRAFT_ONLY, YesNo.YES);
            fromPart.getConfigManager().putSetting(Settings.SCHEDULING_MODE, SchedulingMode.RANDOM);
            MemoryCardTestPlots.copyUpgradesToNetworkInv(fromPart, networkToolInv);
            CompoundTag settings = new CompoundTag();
            fromPart.exportSettings(SettingsFrom.MEMORY_CARD, settings);
            toPart.importSettings(SettingsFrom.MEMORY_CARD, settings, player);
            MemoryCardTestPlots.assertUpgradeEquals(origin, helper, fromPart, toPart);
            MemoryCardTestPlots.assertConfigEquals(origin, helper, fromPart, toPart);
            if (!toPart.getConfig().keySet().equals(Set.of(AEItemKey.of((ItemLike)Items.f_42398_), AEFluidKey.of((Fluid)Fluids.f_76193_)))) {
                helper.m_177289_("wrong filter", origin);
            }
            helper.m_177412_();
        });
    }

    @TestPlot(value="memcard_interface")
    public static void testInterface(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.cable(origin).part(Direction.WEST, AEParts.INTERFACE);
        plot.block(origin.m_122029_(), AEBlocks.INTERFACE);
        plot.test(helper -> {
            InterfaceBlockEntity from = (InterfaceBlockEntity)helper.m_177347_(BlockPos.f_121853_.m_122029_());
            InterfacePart to = helper.getPart(BlockPos.f_121853_, Direction.WEST, InterfacePart.class);
            Player player = helper.m_177368_();
            InternalInventory networkToolInv = MemoryCardTestPlots.addNetworkToolToPlayer(player);
            from.getUpgrades().addItems(AEItems.FUZZY_CARD.stack());
            to.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            from.getConfig().setStack(0, new GenericStack(AEItemKey.of((ItemLike)Items.f_42398_), 1L));
            from.getConfig().setStack(1, new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76193_), 1L));
            from.getConfigManager().putSetting(Settings.FUZZY_MODE, FuzzyMode.PERCENT_25);
            MemoryCardTestPlots.copyUpgradesToNetworkInv(from, networkToolInv);
            CompoundTag settings = new CompoundTag();
            from.exportSettings(SettingsFrom.MEMORY_CARD, settings, null);
            to.importSettings(SettingsFrom.MEMORY_CARD, settings, player);
            MemoryCardTestPlots.assertUpgradeEquals(origin, helper, from, to);
            MemoryCardTestPlots.assertConfigEquals(origin, helper, from, to);
            if (!Objects.equals(to.getConfig().getKey(0), AEItemKey.of((ItemLike)Items.f_42398_))) {
                helper.m_177289_("missing stick in filter", origin);
            }
            if (!Objects.equals(to.getConfig().getKey(1), AEFluidKey.of((Fluid)Fluids.f_76193_))) {
                helper.m_177289_("missing water in filter", origin);
            }
            helper.m_177412_();
        });
    }

    @TestPlot(value="memcard_pattern_provider")
    public static void testPatternProvider(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.cable(origin).part(Direction.WEST, AEParts.PATTERN_PROVIDER);
        plot.block(origin.m_122029_(), AEBlocks.PATTERN_PROVIDER);
        plot.test(helper -> {
            ItemStack processingPattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76193_), 1L)}, new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76195_), 1L)}, "Dev");
            ItemStack craftingPattern = CraftingPatternHelper.encodeShapelessCraftingRecipe((Level)helper.m_177100_(), "Dev", Items.f_41837_.m_7968_());
            ItemStack differentCraftingPattern = CraftingPatternHelper.encodeShapelessCraftingRecipe((Level)helper.m_177100_(), "Dev", Items.f_41838_.m_7968_());
            PatternProviderBlockEntity from = (PatternProviderBlockEntity)helper.m_177347_(BlockPos.f_121853_.m_122029_());
            PatternProviderPart to = helper.getPart(BlockPos.f_121853_, Direction.WEST, PatternProviderPart.class);
            Player player = helper.m_177368_();
            player.m_150109_().m_150079_(AEItems.BLANK_PATTERN.stack(64));
            InternalInventory fromPatternInv = from.getLogic().getPatternInv();
            fromPatternInv.addItems(processingPattern);
            fromPatternInv.addItems(craftingPattern);
            InternalInventory toPatternInv = to.getLogic().getPatternInv();
            toPatternInv.addItems(differentCraftingPattern.m_41777_());
            toPatternInv.addItems(differentCraftingPattern.m_41777_());
            toPatternInv.addItems(differentCraftingPattern.m_41777_());
            int blankPatternsBefore = player.m_150109_().m_18947_((Item)AEItems.BLANK_PATTERN.m_5456_());
            CompoundTag settings = new CompoundTag();
            from.exportSettings(SettingsFrom.MEMORY_CARD, settings, null);
            to.importSettings(SettingsFrom.MEMORY_CARD, settings, player);
            int blankPatternsAfter = player.m_150109_().m_18947_((Item)AEItems.BLANK_PATTERN.m_5456_());
            helper.check(blankPatternsAfter == blankPatternsBefore + 1, "Expected player to be given back one blank pattern");
            for (int i = 0; i < fromPatternInv.size(); ++i) {
                ItemStack toItem;
                ItemStack fromItem = fromPatternInv.getStackInSlot(i);
                if (ItemStack.m_150942_((ItemStack)fromItem, (ItemStack)(toItem = toPatternInv.getStackInSlot(i)))) continue;
                helper.m_177289_("Mismatch in slot " + i, origin.m_122029_());
            }
            helper.m_177412_();
        });
    }

    private static InternalInventory addNetworkToolToPlayer(Player player) {
        player.m_36356_(AEItems.NETWORK_TOOL.stack());
        return NetworkToolItem.findNetworkToolInv(player).getInventory();
    }

    private static void assertUpgradeEquals(BlockPos origin, PlotTestHelper helper, Object fromPart, Object toPart) {
        if (fromPart instanceof IUpgradeableObject) {
            IUpgradeableObject upgradableFrom = (IUpgradeableObject)fromPart;
            IUpgradeableObject upgradeableTo = (IUpgradeableObject)toPart;
            for (ItemStack upgrade : upgradableFrom.getUpgrades()) {
                if (upgradableFrom.getInstalledUpgrades((ItemLike)upgrade.m_41720_()) == upgradeableTo.getInstalledUpgrades((ItemLike)upgrade.m_41720_())) continue;
                helper.m_177289_(upgrade.m_41786_().getString() + " mismatch", origin);
            }
        }
    }

    private static void assertConfigEquals(BlockPos origin, PlotTestHelper helper, Object fromPart, Object toPart) {
        if (fromPart instanceof IConfigurableObject) {
            IConfigurableObject fromConfigurable = (IConfigurableObject)fromPart;
            IConfigurableObject toConfigurable = (IConfigurableObject)toPart;
            IConfigManager fromConfig = fromConfigurable.getConfigManager();
            IConfigManager toConfig = toConfigurable.getConfigManager();
            for (Setting<?> setting : fromConfig.getSettings()) {
                if (((Enum)fromConfig.getSetting(setting)).equals(toConfig.getSetting(setting))) continue;
                helper.m_177289_("Setting " + setting + " mismatch", origin);
            }
        }
    }

    private static void copyUpgradesToNetworkInv(Object fromPart, InternalInventory networkToolInv) {
        if (fromPart instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeable = (IUpgradeableObject)fromPart;
            for (ItemStack upgrade : upgradeable.getUpgrades()) {
                networkToolInv.addItems(upgrade.m_41777_());
            }
        }
    }
}

