/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;

class CraftingPatternEncoding {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_SUBSITUTE_FLUIDS = "substituteFluids";
    private static final String NBT_RECIPE_ID = "recipe";
    private static final String NBT_AUTHOR = "author";

    CraftingPatternEncoding() {
    }

    public static GenericStack[] getCraftingInputs(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        ListTag tag = nbt.m_128437_(NBT_INPUTS, 10);
        Preconditions.checkArgument((tag.size() <= 9 ? 1 : 0) != 0, (Object)"Cannot use more than 9 ingredients");
        GenericStack[] result = new GenericStack[tag.size()];
        for (int x = 0; x < tag.size(); ++x) {
            CompoundTag ingredientTag = tag.m_128728_(x);
            if (ingredientTag.m_128456_()) continue;
            result[x] = GenericStack.fromItemStack(ItemStack.m_41712_((CompoundTag)ingredientTag));
        }
        return result;
    }

    public static boolean canSubstitute(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.m_128471_(NBT_SUBSITUTE);
    }

    public static boolean canSubstituteFluids(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.m_128471_(NBT_SUBSITUTE_FLUIDS);
    }

    public static ResourceLocation getRecipeId(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new ResourceLocation(nbt.m_128461_(NBT_RECIPE_ID));
    }

    public static ItemStack getCraftingResult(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_OUTPUTS));
    }

    public static String getAuthor(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.m_128461_(NBT_AUTHOR);
    }

    public static void encodeCraftingPattern(CompoundTag tag, CraftingRecipe recipe, ItemStack[] sparseInputs, ItemStack output, boolean allowSubstitution, boolean allowFluidSubstitution, String author) {
        tag.m_128365_(NBT_INPUTS, (Tag)CraftingPatternEncoding.encodeItemStackList(sparseInputs));
        tag.m_128379_(NBT_SUBSITUTE, allowSubstitution);
        tag.m_128379_(NBT_SUBSITUTE_FLUIDS, allowFluidSubstitution);
        tag.m_128365_(NBT_OUTPUTS, (Tag)output.m_41739_(new CompoundTag()));
        tag.m_128359_(NBT_RECIPE_ID, recipe.m_6423_().toString());
        tag.m_128359_(NBT_AUTHOR, author);
    }

    private static ListTag encodeItemStackList(ItemStack[] stacks) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) {
                tag.add((Object)new CompoundTag());
                continue;
            }
            tag.add((Object)stack.m_41739_(new CompoundTag()));
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }
}

