/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.core.AEConfig;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class CraftingJobStatusPacket
extends BasePacket {
    private UUID jobId;
    private AEKey what;
    private long requestedAmount;
    private long remainingAmount;
    private long elapsedTime;
    private boolean isFollowing;
    private Status status;

    public CraftingJobStatusPacket(FriendlyByteBuf stream) {
        this.jobId = stream.m_130259_();
        this.status = (Status)stream.m_130066_(Status.class);
        this.what = AEKey.readKey(stream);
        this.requestedAmount = stream.readLong();
        this.remainingAmount = stream.readLong();
        this.elapsedTime = stream.readLong();
        this.isFollowing = stream.readBoolean();
    }

    public CraftingJobStatusPacket(UUID jobId, AEKey what, long requestedAmount, long remainingAmount, long elapsedTime, Status status) {
        this(jobId, what, requestedAmount, remainingAmount, elapsedTime, false, status);
    }

    public CraftingJobStatusPacket(UUID jobId, AEKey what, long requestedAmount, long remainingAmount, long elapsedTime, boolean isFollowing, Status status) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130077_(jobId);
        data.m_130068_((Enum)status);
        AEKey.writeKey(data, what);
        data.writeLong(requestedAmount);
        data.writeLong(remainingAmount);
        data.writeLong(elapsedTime);
        data.writeBoolean(isFollowing);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(Player player) {
        if (this.status == Status.STARTED && AEConfig.instance().isPinAutoCraftedItems()) {
            PinnedKeys.pinKey(this.what, PinnedKeys.PinReason.CRAFTING);
        }
        PendingCraftingJobs.jobStatus(this.jobId, this.what, this.requestedAmount, this.remainingAmount, this.elapsedTime, this.isFollowing, this.status);
    }

    public static enum Status {
        STARTED,
        CANCELLED,
        FINISHED;

    }
}

