/*
 * This file is part of Applied Energistics 2.
 * Copyright (c) 2021, TeamAppliedEnergistics, All rights reserved.
 *
 * Applied Energistics 2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Applied Energistics 2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Applied Energistics 2.  If not, see <http://www.gnu.org/licenses/lgpl>.
 */

package appeng.init.client;

import java.util.function.BiConsumer;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;

import appeng.client.render.tesr.SkyChestTESR;
import appeng.core.definitions.AEEntities;

/**
 * Registers custom renderers for our {@link AEEntities}.
 */
public final class InitEntityLayerDefinitions {

    private InitEntityLayerDefinitions() {
    }

    public static void init(BiConsumer<ModelLayerLocation, LayerDefinition> consumer) {
        consumer.accept(SkyChestTESR.MODEL_LAYER, SkyChestTESR.createSingleBodyLayer());
    }

}
