/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.Rects;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.NumberUtil;
import com.google.common.primitives.Longs;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class NumberEntryWidget
implements ICompositeWidget {
    public final long[] stepsBase;
    public final long[] stepsAlt;
    private final Component[] components1000;
    private final Component[] components64;
    private static final Component PLUS = Component.m_237113_((String)"+");
    private static final Component MINUS = Component.m_237113_((String)"-");
    private static final int UNIT_PADDING = 3;
    private final int errorTextColor;
    private final int normalTextColor;
    private final ConfirmableTextField textField;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type;
    private List<Button> buttons;
    private long minValue;
    private long maxValue = Long.MAX_VALUE;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);
    private Rect2i textFieldBounds = Rects.ZERO;
    private Point currentScreenOrigin = Point.ZERO;
    private List<Button> amountButtons = List.of();
    protected final AEConfig config = AEConfig.instance();

    public NumberEntryWidget(ScreenStyle style, NumberEntryType type) {
        this.stepsBase = new long[]{this.config.getNumberWidgetValue(0), this.config.getNumberWidgetValue(1), this.config.getNumberWidgetValue(2), this.config.getNumberWidgetValue(3)};
        this.stepsAlt = new long[]{this.config.getNumberWidgetValue(4), this.config.getNumberWidgetValue(5), this.config.getNumberWidgetValue(6), this.config.getNumberWidgetValue(7)};
        this.errorTextColor = style.getColor(PaletteColor.TEXTFIELD_ERROR).toARGB();
        this.normalTextColor = style.getColor(PaletteColor.TEXTFIELD_TEXT).toARGB();
        this.type = Objects.requireNonNull(type, "type");
        this.decimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        this.textField = new ConfirmableTextField(style, font, 0, 0, 0, 9);
        this.textField.m_94182_(false);
        this.textField.m_94199_(16);
        this.textField.m_94202_(this.normalTextColor);
        this.textField.m_94194_(true);
        this.textField.m_94151_(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
        this.components1000 = new Component[]{this.makeLabel(PLUS, 0, true), this.makeLabel(PLUS, 1, true), this.makeLabel(PLUS, 2, true), this.makeLabel(PLUS, 3, true), this.makeLabel(MINUS, 0, true), this.makeLabel(MINUS, 1, true), this.makeLabel(MINUS, 2, true), this.makeLabel(MINUS, 3, true)};
        this.components64 = new Component[]{this.makeLabel(PLUS, 0, false), this.makeLabel(PLUS, 1, false), this.makeLabel(PLUS, 2, false), this.makeLabel(PLUS, 3, false), this.makeLabel(MINUS, 0, false), this.makeLabel(MINUS, 1, false), this.makeLabel(MINUS, 2, false), this.makeLabel(MINUS, 3, false)};
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.m_94186_(active);
        this.buttons.forEach(b -> {
            b.f_93623_ = active;
        });
    }

    public void setTextFieldBounds(Rect2i bounds) {
        this.textFieldBounds = bounds;
        this.textField.move(this.currentScreenOrigin.move(bounds.m_110085_(), bounds.m_110086_()));
        int unitWidth = 0;
        if (this.type.unit() != null) {
            unitWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.type.unit()) + 3;
        }
        this.textField.resize(bounds.m_110090_() - unitWidth, bounds.m_110091_());
    }

    public void setTextFieldStyle(WidgetStyle style) {
        int left = 0;
        if (style.getLeft() != null) {
            left = style.getLeft();
        }
        int top = 0;
        if (style.getTop() != null) {
            top = style.getTop();
        }
        this.setTextFieldBounds(new Rect2i(left, top, style.getWidth(), style.getHeight()));
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.validate();
    }

    @Override
    public void setPosition(Point position) {
        this.bounds = new Rect2i(position.getX(), position.getY(), this.bounds.m_110090_(), this.bounds.m_110091_());
    }

    @Override
    public void setSize(int width, int height) {
        this.bounds = new Rect2i(this.bounds.m_110085_(), this.bounds.m_110086_(), width, height);
    }

    @Override
    public Rect2i getBounds() {
        return this.bounds;
    }

    @Override
    public void populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen) {
        int left = bounds.m_110085_() + this.bounds.m_110085_();
        int top = bounds.m_110086_() + this.bounds.m_110086_();
        ArrayList<Button> buttons = new ArrayList<Button>(9);
        buttons.add(Button.m_253074_((Component)this.components1000[0], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? this.stepsAlt[0] : this.stepsBase[0])).m_252987_(left, top, 22, 20).m_253136_());
        buttons.add(Button.m_253074_((Component)this.components1000[1], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? this.stepsAlt[1] : this.stepsBase[1])).m_252987_(left + 28, top, 28, 20).m_253136_());
        buttons.add(Button.m_253074_((Component)this.components1000[2], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? this.stepsAlt[2] : this.stepsBase[2])).m_252987_(left + 62, top, 32, 20).m_253136_());
        buttons.add(Button.m_253074_((Component)this.components1000[3], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? this.stepsAlt[3] : this.stepsBase[3])).m_252987_(left + 100, top, 38, 20).m_253136_());
        buttons.forEach(addWidget);
        this.currentScreenOrigin = Point.fromTopLeft(bounds);
        this.setTextFieldBounds(this.textFieldBounds);
        screen.m_264313_((GuiEventListener)this.textField);
        addWidget.accept((AbstractWidget)this.textField);
        buttons.add(Button.m_253074_((Component)this.components1000[4], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? -this.stepsAlt[0] : -this.stepsBase[0])).m_252987_(left, top + 42, 22, 20).m_253136_());
        buttons.add(Button.m_253074_((Component)this.components1000[5], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? -this.stepsAlt[1] : -this.stepsBase[1])).m_252987_(left + 28, top + 42, 28, 20).m_253136_());
        buttons.add(Button.m_253074_((Component)this.components1000[6], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? -this.stepsAlt[2] : -this.stepsBase[2])).m_252987_(left + 62, top + 42, 32, 20).m_253136_());
        buttons.add(Button.m_253074_((Component)this.components1000[7], btn -> this.addQty(NumberEntryWidget.hasShiftOrControlDown() ? -this.stepsAlt[3] : -this.stepsBase[3])).m_252987_(left + 100, top + 42, 38, 20).m_253136_());
        this.amountButtons = List.copyOf(buttons);
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon();
            this.validationIcon.m_252865_(left + 104);
            this.validationIcon.m_253211_(top + 27);
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addWidget);
        this.buttons = buttons;
        this.validate();
    }

    @Override
    public void updateBeforeRender() {
        Component[] messages = NumberEntryWidget.hasShiftOrControlDown() ? this.components64 : this.components1000;
        for (int i = 0; i < this.amountButtons.size(); ++i) {
            this.amountButtons.get(i).m_93666_(messages[i]);
        }
    }

    private static boolean hasShiftOrControlDown() {
        return Screen.m_96638_() || Screen.m_96637_();
    }

    public boolean startsWithEquals() {
        return this.textField.m_94155_().startsWith("=");
    }

    public OptionalInt getIntValue() {
        OptionalLong value = this.getLongValue();
        if (value.isPresent()) {
            long longValue = value.getAsLong();
            if (longValue > Integer.MAX_VALUE) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((int)longValue);
        }
        return OptionalInt.empty();
    }

    public OptionalLong getLongValue() {
        double internalValue = this.getValueInternal();
        if (Double.isNaN(internalValue)) {
            return OptionalLong.empty();
        }
        if (this.type.amountPerUnit() == 1 && this.hasDecimalPart(internalValue)) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue);
        if (externalValue < this.minValue) {
            return OptionalLong.empty();
        }
        if (externalValue > this.maxValue) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    private boolean hasDecimalPart(double value) {
        return value != Math.floor(value);
    }

    public void setLongValue(long value) {
        double internalValue = this.convertToInternalValue(Longs.constrainToRange((long)value, (long)this.minValue, (long)this.maxValue));
        this.textField.m_94144_(this.decimalFormat.format(internalValue));
        this.textField.m_94201_();
        this.textField.m_94208_(0);
        this.validate();
    }

    private void addQty(long delta) {
        double currentValue = this.getValueInternal();
        if (Double.isNaN(currentValue)) {
            currentValue = 0.0;
        }
        double newValue = currentValue + (double)delta;
        double minimum = this.convertToInternalValue(this.minValue);
        double maximum = this.convertToInternalValue(this.maxValue);
        if (newValue < minimum) {
            newValue = minimum;
        } else if (newValue > maximum) {
            newValue = maximum;
        } else if (currentValue == 1.0 && delta > 0L && (delta % 10L == 0L || delta % 16L == 0L)) {
            newValue -= 1.0;
        }
        this.setValueInternal(newValue);
    }

    private double getValueInternal() {
        String textValue = this.textField.m_94155_();
        if (textValue.startsWith("=")) {
            textValue = textValue.substring(1);
        }
        return Math.min(Math.pow(2.0, 60.0), NumberUtil.parse(textValue));
    }

    private boolean isNumber() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.textField.m_94155_().trim();
        this.decimalFormat.parse(textValue, position);
        return position.getErrorIndex() == -1 && position.getIndex() == textValue.length();
    }

    private void setValueInternal(double value) {
        this.textField.m_94144_(this.decimalFormat.format(value));
    }

    private void validate() {
        ArrayList<MutableComponent> validationErrors = new ArrayList<MutableComponent>();
        ArrayList<Component> infoMessages = new ArrayList<Component>();
        double value = this.getValueInternal();
        if (!Double.isNaN(value)) {
            if (this.type.amountPerUnit() == 1 && this.hasDecimalPart(value)) {
                validationErrors.add(GuiText.NumberNonInteger.text());
            } else {
                long externalValue = this.convertToExternalValue(value);
                if (externalValue < this.minValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.minValue));
                    validationErrors.add(GuiText.NumberLessThanMinValue.text(formatted));
                } else if (externalValue > this.maxValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.maxValue));
                    validationErrors.add(GuiText.NumberGreaterThanMaxValue.text(formatted));
                } else if (!this.isNumber()) {
                    infoMessages.add((Component)Component.m_237113_((String)("= " + this.decimalFormat.format(value))));
                }
            }
        } else {
            validationErrors.add(GuiText.InvalidNumber.text());
        }
        boolean valid = validationErrors.isEmpty();
        ArrayList<Component> tooltip = valid ? infoMessages : validationErrors;
        this.textField.m_94202_(valid ? this.normalTextColor : this.errorTextColor);
        this.textField.setTooltipMessage(tooltip);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(tooltip);
        }
    }

    private Component makeLabel(Component prefix, int amountIndex, boolean useDecimalSteps) {
        return prefix.m_6879_().m_130946_(this.decimalFormat.format(useDecimalSteps ? this.stepsBase[amountIndex] : this.stepsAlt[amountIndex]));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }

    public NumberEntryType getType() {
        return this.type;
    }

    public void setType(NumberEntryType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.setTextFieldBounds(this.textFieldBounds);
        if (this.onChange != null) {
            this.onChange.run();
        }
        this.validate();
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        if (this.type.unit() != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            int x = bounds.m_110085_() + this.textFieldBounds.m_110085_() + this.textFieldBounds.m_110090_() - font.m_92895_(this.type.unit());
            float f = bounds.m_110086_() + this.textFieldBounds.m_110086_();
            int n = this.textFieldBounds.m_110091_();
            Objects.requireNonNull(font);
            int y = (int)(f + (float)(n - 9) / 2.0f + 1.0f);
            guiGraphics.m_280056_(font, this.type.unit(), x, y, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
        }
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        double value;
        if (this.textFieldBounds.m_110087_(mousePos.getX(), mousePos.getY()) && !Double.isNaN(value = this.getValueInternal())) {
            if (delta < 0.0) {
                this.addQty(-1L);
            } else if (delta > 0.0) {
                this.addQty(1L);
            }
            return true;
        }
        return false;
    }

    private long convertToExternalValue(double internalValue) {
        double multiplicand = this.type.amountPerUnit();
        double value = internalValue * multiplicand;
        return (long)Math.ceil(value);
    }

    private double convertToInternalValue(long externalValue) {
        double divisor = this.type.amountPerUnit();
        return (double)externalValue / divisor;
    }
}

