/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.pathing.ControllerState;
import appeng.blockentity.networking.ControllerBlockEntity;
import appeng.core.AEConfig;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class ControllerValidator
implements IGridVisitor {
    public static final int MAX_SIZE = AEConfig.instance().getControllerMaxLength();
    private boolean valid = true;
    private int found = 0;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    private ControllerValidator(BlockPos pos) {
        this.minX = pos.m_123341_();
        this.maxX = pos.m_123341_();
        this.minY = pos.m_123342_();
        this.maxY = pos.m_123342_();
        this.minZ = pos.m_123343_();
        this.maxZ = pos.m_123343_();
    }

    public static ControllerState calculateState(Collection<ControllerBlockEntity> controllers) {
        if (controllers.isEmpty()) {
            return ControllerState.NO_CONTROLLER;
        }
        ControllerBlockEntity startingController = controllers.iterator().next();
        IGridNode startingNode = startingController.getGridNode();
        if (startingNode == null) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        ControllerValidator cv = new ControllerValidator(startingController.m_58899_());
        startingNode.beginVisit(cv);
        if (!cv.isValid()) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        if (cv.getFound() != controllers.size()) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        if (ControllerValidator.hasControllerCross(controllers)) {
            return ControllerState.CONTROLLER_CONFLICT;
        }
        return ControllerState.CONTROLLER_ONLINE;
    }

    @Override
    public boolean visitNode(IGridNode node) {
        Object object;
        if (this.isValid() && (object = node.getOwner()) instanceof ControllerBlockEntity) {
            ControllerBlockEntity c = (ControllerBlockEntity)object;
            BlockPos pos = c.m_58899_();
            this.minX = Math.min(pos.m_123341_(), this.minX);
            this.maxX = Math.max(pos.m_123341_(), this.maxX);
            this.minY = Math.min(pos.m_123342_(), this.minY);
            this.maxY = Math.max(pos.m_123342_(), this.maxY);
            this.minZ = Math.min(pos.m_123343_(), this.minZ);
            this.maxZ = Math.max(pos.m_123343_(), this.maxZ);
            if (this.maxX - this.minX < MAX_SIZE && this.maxY - this.minY < MAX_SIZE && this.maxZ - this.minZ < MAX_SIZE) {
                ++this.found;
                return true;
            }
            this.valid = false;
        }
        return false;
    }

    private static boolean hasControllerCross(Collection<ControllerBlockEntity> controllers) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>(controllers.size());
        for (ControllerBlockEntity controller : controllers) {
            posSet.add(controller.m_58899_().m_7949_());
        }
        for (BlockPos pos : posSet) {
            boolean upDown;
            boolean eastWest;
            boolean northSouth = posSet.contains(pos.m_121945_(Direction.NORTH)) && posSet.contains(pos.m_121945_(Direction.SOUTH));
            if ((northSouth ? 1 : 0) + ((eastWest = posSet.contains(pos.m_121945_(Direction.EAST)) && posSet.contains(pos.m_121945_(Direction.WEST))) ? 1 : 0) + ((upDown = posSet.contains(pos.m_121945_(Direction.UP)) && posSet.contains(pos.m_121945_(Direction.DOWN))) ? 1 : 0) <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getFound() {
        return this.found;
    }
}

