/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.PatternBoxMenuHost;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.items.PatternBoxMenu;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternBoxItem
extends AEBaseItem
implements IMenuItem,
AEToolItem {
    public PatternBoxItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public PatternBoxMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        Level level = player.m_9236_();
        if (pos == null) {
            return new PatternBoxMenuHost(player, inventorySlot, stack, null);
        }
        IInWorldGridNodeHost host = GridHelper.getNodeHost(level, pos);
        return new PatternBoxMenuHost(player, inventorySlot, stack, host);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            MenuOpener.open(PatternBoxMenu.TYPE, player, MenuLocators.forHand(player, hand));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.f_46443_), (Object)player.m_21120_(hand));
    }

    @Nullable
    public static PatternBoxMenuHost findPatternBoxHost(Player player) {
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Item item;
            ItemStack item2 = inv.m_8020_(i);
            if (item2.m_41619_() || !((item = item2.m_41720_()) instanceof PatternBoxItem)) continue;
            PatternBoxItem patternBoxItem = (PatternBoxItem)item;
            return patternBoxItem.getMenuHost(player, i, item2, null);
        }
        return null;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        PatternBoxMenuHost host = new PatternBoxMenuHost(null, null, stack, null);
        if (host.getInventory().isEmpty()) {
            return Optional.empty();
        }
        LinkedHashMap<AEItemKey, Integer> patterns = new LinkedHashMap<AEItemKey, Integer>();
        for (ItemStack pattern : host.getInventory()) {
            patterns.merge(AEItemKey.of(pattern), pattern.m_41613_(), Integer::sum);
        }
        ArrayList<GenericStack> stacks = new ArrayList<GenericStack>(patterns.size());
        for (Map.Entry entry : patterns.entrySet()) {
            stacks.add(new GenericStack((AEKey)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        stacks.sort(Comparator.comparingLong(GenericStack::amount).reversed());
        return Optional.of(new StorageCellTooltipComponent(List.of(), stacks, false, true));
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41619_()) {
            return false;
        }
        this.insertIntoTool(stack, other, player);
        return true;
    }

    private void insertIntoTool(ItemStack tool, ItemStack pattern, Player player) {
        PatternBoxMenuHost host = new PatternBoxMenuHost(player, null, tool, null);
        int amount = pattern.m_41613_();
        ItemStack overflow = host.getInventory().addItems(pattern);
        pattern.m_41774_(amount - overflow.m_41613_());
        host.saveChanges();
    }
}

