/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.PatternKeyTooltipComponent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Matrix4f;

public class PatternKeyClientTooltipComponent
implements ClientTooltipComponent {
    private final PatternKeyTooltipComponent tooltipComponent;
    private static final int TEXT_HEIGHT = 10;
    private static final int LINE_HEIGHT = 16;
    private static final int TEXT_PADDING = 20;
    private static final int TEXT_VERTICAL_OFFSET = 4;
    private static final int SECTION_SPACING = 12;
    private static final int AUTHOR_VERTICAL_OFFSET = 6;
    private static final int TOOLTIP_PADDING = 6;
    private static final int INITIAL_IMAGE_OFFSET = 8;

    public PatternKeyClientTooltipComponent(PatternKeyTooltipComponent tooltipComponent) {
        this.tooltipComponent = tooltipComponent;
    }

    public int m_142103_() {
        int height = 0;
        if (!this.tooltipComponent.outputs().isEmpty()) {
            height += 10;
            height += this.tooltipComponent.outputs().size() * 16;
        }
        if (!this.tooltipComponent.inputs().isEmpty()) {
            height += 10;
            height += this.tooltipComponent.inputs().size() * 16;
        }
        if (this.tooltipComponent.isCrafting()) {
            height += 10;
            height += 10;
        }
        if (!this.tooltipComponent.author().isEmpty()) {
            height += 10;
        }
        return height + 6;
    }

    public int m_142069_(Font font) {
        Component text;
        int width = 0;
        if (!this.tooltipComponent.outputs().isEmpty()) {
            MutableComponent outputsLabel = (this.tooltipComponent.isCrafting() ? GuiText.Crafts.text() : GuiText.Produces.text()).m_130940_(ChatFormatting.DARK_AQUA);
            width = Math.max(width, font.m_92852_((FormattedText)outputsLabel) + 20);
            for (GenericStack output : this.tooltipComponent.outputs()) {
                text = this.getStackText(output, false);
                width = Math.max(width, font.m_92852_((FormattedText)text) + 20);
            }
        }
        if (!this.tooltipComponent.inputs().isEmpty()) {
            MutableComponent inputsLabel = GuiText.Ingredients.text().m_130940_(ChatFormatting.DARK_GREEN);
            width = Math.max(width, font.m_92852_((FormattedText)inputsLabel) + 20);
            for (GenericStack input : this.tooltipComponent.inputs()) {
                text = this.getStackText(input, true);
                width = Math.max(width, font.m_92852_((FormattedText)text) + 20);
            }
        }
        if (this.tooltipComponent.isCrafting()) {
            MutableComponent substitutionLabel = GuiText.Substitute.text(this.tooltipComponent.canSubstitute());
            MutableComponent fluidSubstitutionLabel = GuiText.FluidSubstitutions.text(this.tooltipComponent.canSubstituteFluids());
            width = Math.max(width, font.m_92852_((FormattedText)substitutionLabel));
            width = Math.max(width, font.m_92852_((FormattedText)fluidSubstitutionLabel));
        }
        return width;
    }

    public void m_142440_(Font font, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        List<GenericStack> inputs;
        int currentY = y;
        List<GenericStack> outputs = this.tooltipComponent.outputs();
        if (!outputs.isEmpty()) {
            MutableComponent outputsLabel = (this.tooltipComponent.isCrafting() ? GuiText.Crafts.text() : GuiText.Produces.text()).m_130940_(ChatFormatting.DARK_AQUA);
            font.m_272077_((Component)outputsLabel, (float)x, (float)currentY, -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
            currentY += 10;
            for (GenericStack genericStack : outputs) {
                Component text = this.getStackText(genericStack, false);
                font.m_272077_(text, (float)(x + 20), (float)(currentY + 4), -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
                if (outputs.indexOf(genericStack) < outputs.size() - 1) {
                    currentY += 16;
                    continue;
                }
                currentY += 14;
            }
        }
        if (!(inputs = this.tooltipComponent.inputs()).isEmpty()) {
            MutableComponent inputsLabel = GuiText.Ingredients.text().m_130940_(ChatFormatting.DARK_GREEN);
            font.m_272077_((Component)inputsLabel, (float)x, (float)(currentY + 4), -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
            currentY += 16;
            for (GenericStack input : inputs) {
                Component text = this.getStackText(input, true);
                font.m_272077_(text, (float)(x + 20), (float)(currentY + 4), -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
                if (inputs.indexOf(input) < inputs.size() - 1) {
                    currentY += 16;
                    continue;
                }
                currentY += 12;
            }
        }
        if (this.tooltipComponent.isCrafting()) {
            MutableComponent yes = GuiText.Yes.text().m_130940_(ChatFormatting.GREEN);
            MutableComponent mutableComponent = GuiText.No.text().m_130940_(ChatFormatting.RED);
            MutableComponent canSubstitute = this.tooltipComponent.canSubstitute() ? yes : mutableComponent;
            MutableComponent canSubstituteFluids = this.tooltipComponent.canSubstituteFluids() ? yes : mutableComponent;
            MutableComponent substitutionLabel = GuiText.Substitute.text(canSubstitute);
            MutableComponent fluidSubstitutionLabel = GuiText.FluidSubstitutions.text(canSubstituteFluids);
            font.m_272077_((Component)substitutionLabel, (float)x, (float)(currentY + 4), -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
            font.m_272077_((Component)fluidSubstitutionLabel, (float)x, (float)((currentY += 10) + 4), -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
            currentY += 10;
        }
        if (!this.tooltipComponent.author().isEmpty()) {
            MutableComponent authorText = GuiText.EncodedBy.text(this.tooltipComponent.author()).m_130940_(ChatFormatting.LIGHT_PURPLE);
            font.m_272077_((Component)authorText, (float)x, (float)(currentY + 6), -1, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0);
        }
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics guiGraphics) {
        String amtText;
        int currentY = y;
        currentY += 8;
        boolean showAmounts = this.tooltipComponent.showAmounts();
        if (!this.tooltipComponent.outputs().isEmpty()) {
            for (GenericStack output : this.tooltipComponent.outputs()) {
                AEKeyRendering.drawInGui(Minecraft.m_91087_(), guiGraphics, x, currentY, output.what());
                if (showAmounts) {
                    amtText = output.what().formatAmount(output.amount(), AmountFormat.SLOT);
                    StackSizeRenderer.renderSizeLabel(guiGraphics, font, (float)x, (float)currentY, amtText, false);
                }
                currentY += 16;
            }
        }
        currentY += 2;
        if (!this.tooltipComponent.inputs().isEmpty()) {
            currentY += 12;
            for (GenericStack input : this.tooltipComponent.inputs()) {
                AEKeyRendering.drawInGui(Minecraft.m_91087_(), guiGraphics, x, currentY, input.what());
                if (showAmounts) {
                    amtText = input.what().formatAmount(input.amount(), AmountFormat.SLOT);
                    StackSizeRenderer.renderSizeLabel(guiGraphics, font, (float)x, (float)currentY, amtText, false);
                }
                currentY += 16;
            }
        }
    }

    private Component getStackText(GenericStack stack, boolean isInput) {
        AEKeyType type = stack.what().getType();
        AEKey what = stack.what();
        MutableComponent displayName = what.getDisplayName().m_6879_();
        displayName = type == AEKeyType.items() ? displayName.m_130940_(isInput ? ChatFormatting.GREEN : ChatFormatting.YELLOW) : displayName.m_130940_(isInput ? ChatFormatting.AQUA : ChatFormatting.BLUE);
        String amountInfo = what.formatAmount(stack.amount(), AmountFormat.FULL);
        return Component.m_237113_((String)(amountInfo + " \u00a77x ")).m_7220_((Component)displayName);
    }
}

