/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.config.ActionItems;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.IPagedScreen;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.ItemListMod;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.MEStorageMenu;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class TerminalSettingsScreen<C extends MEStorageMenu>
extends AESubScreen<C, MEStorageScreen<C>>
implements IPagedScreen {
    private final String TEXT_SEARCH_SETTINGS_TITLE = "search_settings_title";
    private final AECheckbox pinAutoCraftedItemsCheckbox;
    private final AECheckbox notifyForFinishedCraftingJobsCheckbox;
    private final AECheckbox clearGridOnCloseCheckbox;
    private final AECheckbox useInternalSearchRadio;
    private final AECheckbox useExternalSearchRadio;
    private final AECheckbox rememberCheckbox;
    private final AECheckbox autoFocusCheckbox;
    private final AECheckbox syncWithExternalCheckbox;
    private final AECheckbox clearExternalCheckbox;
    private final AECheckbox autoPauseTerminalCheckbox;
    private final ActionButton nextPageButton;
    private final ActionButton previousPageButton;
    private final Object2IntOpenHashMap<AbstractWidget> pages = new Object2IntOpenHashMap();
    private int page = 0;

    public TerminalSettingsScreen(MEStorageScreen<C> parent) {
        super(parent, "/screens/terminals/terminal_settings.json");
        boolean hasExternalSearch;
        MutableComponent externalSearchMod;
        this.addBackButton();
        if (ItemListMod.isEnabled()) {
            externalSearchMod = Component.m_237113_((String)ItemListMod.getShortName());
            hasExternalSearch = true;
        } else {
            externalSearchMod = Component.m_237113_((String)"JEI/REI/EMI");
            hasExternalSearch = false;
        }
        this.pinAutoCraftedItemsCheckbox = this.makeCheckbox("pinAutoCraftedItemsCheckbox", (Component)GuiText.TerminalSettingsPinAutoCraftedItems.text(), this::save);
        this.notifyForFinishedCraftingJobsCheckbox = this.makeCheckbox("notifyForFinishedCraftingJobsCheckbox", (Component)GuiText.TerminalSettingsNotifyForFinishedJobs.text(), this::save);
        this.clearGridOnCloseCheckbox = this.makeCheckbox("clearGridOnCloseCheckbox", (Component)GuiText.TerminalSettingsClearGridOnClose.text(), this::save);
        this.useInternalSearchRadio = this.makeCheckbox("useInternalSearchRadio", (Component)GuiText.SearchSettingsUseInternalSearch.text(), this::switchToAeSearch);
        this.useInternalSearchRadio.setRadio(true);
        this.useExternalSearchRadio = this.makeCheckbox("useExternalSearchRadio", (Component)GuiText.SearchSettingsUseExternalSearch.text(externalSearchMod), this::switchToExternalSearch);
        this.useExternalSearchRadio.setRadio(true);
        this.useExternalSearchRadio.f_93624_ = hasExternalSearch;
        this.rememberCheckbox = this.makeCheckbox("rememberCheckbox", (Component)GuiText.SearchSettingsRememberSearch.text(), this::save);
        this.autoFocusCheckbox = this.makeCheckbox("autoFocusCheckbox", (Component)GuiText.SearchSettingsAutoFocus.text(), this::save);
        this.syncWithExternalCheckbox = this.makeCheckbox("syncWithExternalCheckbox", (Component)GuiText.SearchSettingsSyncWithExternal.text(externalSearchMod), this::save);
        this.clearExternalCheckbox = this.makeCheckbox("clearExternalCheckbox", (Component)GuiText.SearchSettingsClearExternal.text(externalSearchMod), this::save);
        this.autoPauseTerminalCheckbox = this.makeCheckbox("autoPauseTerminalCheckbox", (Component)GuiText.TerminalSettingsAutoPause.text(), this::save);
        this.nextPageButton = this.addToLeftToolbar(new ActionButton(ActionItems.NEXT_PAGE, () -> this.setCurrentPage(this.page + 1)));
        this.previousPageButton = this.addToLeftToolbar(new ActionButton(ActionItems.PREV_PAGE, () -> this.setCurrentPage(this.page - 1)));
        this.updateState();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setSlotsHidden(SlotSemantics.TOOLBOX, true);
        this.setSlotsHidden(SlotSemantics.PATTERNBOX, true);
    }

    private void switchToAeSearch() {
        this.useInternalSearchRadio.setSelected(true);
        this.useExternalSearchRadio.setSelected(false);
        this.save();
    }

    private void switchToExternalSearch() {
        this.useInternalSearchRadio.setSelected(false);
        this.useExternalSearchRadio.setSelected(true);
        this.save();
    }

    private void addBackButton() {
        ItemStack icon = ((MEStorageMenu)this.f_97732_).getHost().getMainMenuIcon();
        Component label = icon.m_41786_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        TabButton button = new TabButton(icon, label, btn -> this.returnToParent());
        this.widgets.add("back", (AbstractWidget)button);
    }

    private void updateState() {
        this.pinAutoCraftedItemsCheckbox.setSelected(this.config.isPinAutoCraftedItems());
        this.notifyForFinishedCraftingJobsCheckbox.setSelected(this.config.isNotifyForFinishedCraftingJobs());
        this.clearGridOnCloseCheckbox.setSelected(this.config.isClearGridOnClose());
        this.useInternalSearchRadio.setSelected(!this.config.isUseExternalSearch());
        this.useExternalSearchRadio.setSelected(this.config.isUseExternalSearch());
        this.rememberCheckbox.setSelected(this.config.isRememberLastSearch());
        this.autoFocusCheckbox.setSelected(this.config.isAutoFocusSearch());
        this.syncWithExternalCheckbox.setSelected(this.config.isSyncWithExternalSearch());
        this.clearExternalCheckbox.setSelected(this.config.isClearExternalSearchOnOpen());
        this.autoPauseTerminalCheckbox.setSelected(this.config.isAutoPauseTerminal());
        int highestPage = 0;
        for (Object2IntMap.Entry entry : this.pages.object2IntEntrySet()) {
            AbstractWidget widget = (AbstractWidget)entry.getKey();
            widget.f_93624_ = entry.getIntValue() == this.page;
            highestPage = Math.max(highestPage, entry.getIntValue());
        }
        this.rememberCheckbox.f_93624_ = this.useInternalSearchRadio.isSelected() && this.useInternalSearchRadio.f_93624_;
        this.autoFocusCheckbox.f_93624_ = this.useInternalSearchRadio.isSelected() && this.useInternalSearchRadio.f_93624_;
        this.syncWithExternalCheckbox.f_93624_ = this.useInternalSearchRadio.isSelected() && this.useInternalSearchRadio.f_93624_;
        this.clearExternalCheckbox.f_93624_ = this.useExternalSearchRadio.isSelected() && this.useExternalSearchRadio.f_93624_;
        this.setTextHidden("search_settings_title", !this.useInternalSearchRadio.f_93624_);
        this.nextPageButton.f_93624_ = this.page < highestPage;
        this.previousPageButton.f_93624_ = this.page > 0;
    }

    private void save() {
        this.config.setUseExternalSearch(this.useExternalSearchRadio.isSelected());
        this.config.setRememberLastSearch(this.rememberCheckbox.isSelected());
        this.config.setAutoFocusSearch(this.autoFocusCheckbox.isSelected());
        this.config.setSyncWithExternalSearch(this.syncWithExternalCheckbox.isSelected());
        this.config.setClearExternalSearchOnOpen(this.clearExternalCheckbox.isSelected());
        this.config.setPinAutoCraftedItems(this.pinAutoCraftedItemsCheckbox.isSelected());
        this.config.setNotifyForFinishedCraftingJobs(this.notifyForFinishedCraftingJobsCheckbox.isSelected());
        this.config.setClearGridOnClose(this.clearGridOnCloseCheckbox.isSelected());
        this.config.setAutoPauseTerminal(this.autoPauseTerminalCheckbox.isSelected());
        this.updateState();
    }

    private AECheckbox makeCheckbox(String id, Component text, Runnable changeListener) {
        AECheckbox checkbox = this.widgets.addCheckbox(id, text, changeListener);
        this.pages.put((Object)checkbox, this.style.getWidget(id).getPage());
        return checkbox;
    }

    @Override
    public int getCurrentPage() {
        return this.page;
    }

    @Override
    public void setCurrentPage(int page) {
        this.page = page;
        this.updateState();
    }
}

