/*
 * This file is part of Applied Energistics 2.
 * Copyright (c) 2013 - 2015, AlgorithmX2, All rights reserved.
 *
 * Applied Energistics 2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Applied Energistics 2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Applied Energistics 2.  If not, see <http://www.gnu.org/licenses/lgpl>.
 */

package appeng.util;

import java.util.concurrent.Callable;

import org.jetbrains.annotations.Nullable;

import net.minecraft.world.level.Level;

/**
 * An interface similar to {@link Callable}, but allowing to pass the {@link Level} when calling.
 *
 * @author yueh
 * @version rv3
 * @see Callable
 * @since rv3
 */
@FunctionalInterface
public interface ILevelRunnable {
    /**
     * Similar to {@link Callable#call()}
     *
     * @param level this param is given to not hold a reference to the level but let the caller handle it. Do not expect
     *              a level here thus can be <tt>null</tt>.
     * @throws Exception if the call fails
     * @see Runnable#run()
     */
    void call(@Nullable Level level) throws Exception;
}
