/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.menu.implementations.PatternAccessTermMenu;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class QuickMovePatternPacket
extends BasePacket {
    private int containerId;
    private int clickedSlot;
    private List<Long> allowedPatternContainers;

    public QuickMovePatternPacket(FriendlyByteBuf stream) {
        this.containerId = stream.m_130242_();
        this.clickedSlot = stream.m_130242_();
        int count = stream.m_130242_();
        this.allowedPatternContainers = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            this.allowedPatternContainers.add(stream.m_130258_());
        }
    }

    public QuickMovePatternPacket(int containerId, int clickedSlot, List<Long> allowedPatternContainers) {
        this.containerId = containerId;
        this.clickedSlot = clickedSlot;
        this.allowedPatternContainers = allowedPatternContainers;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130130_(containerId);
        data.m_130130_(clickedSlot);
        data.m_130130_(allowedPatternContainers.size());
        allowedPatternContainers.forEach(arg_0 -> ((FriendlyByteBuf)data).m_130103_(arg_0));
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player.f_36096_.f_38840_ == this.containerId && (abstractContainerMenu = player.f_36096_) instanceof PatternAccessTermMenu) {
            PatternAccessTermMenu menu = (PatternAccessTermMenu)abstractContainerMenu;
            menu.quickMovePattern(player, this.clickedSlot, this.allowedPatternContainers);
        }
    }
}

